<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template name="total-sales-value">
		<xsl:param name="list" />
		<xsl:choose>
			<xsl:when test="$list">
				<xsl:variable name="first" select="$list[1]" />
				<xsl:variable name="total-of-rest">
					<xsl:call-template name="total-sales-value">
						<xsl:with-param name="list" select="$list[position()!=1]" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$first/sales * $first/price + $total-of-rest" />
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="/">
	<xsl:variable name="total">
			<xsl:call-template name="total-sales-value">
				<xsl:with-param name="list" select="//book" />
			</xsl:call-template>
		</xsl:variable>
	Total sales value is <xsl:value-of select="number($total)" />
	</xsl:template>
</xsl:stylesheet>